<?php
session_start();

// Habilitar exibição de erros para depuração
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Conexão com o banco de dados
$host = 'localhost';
$db_name = 'mavilamr_block';
$db_username = 'mavilamr_block';
$db_password = 'vmGwGNP8TfczUfxQatb6';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db_name", $db_username, $db_password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Verifica se as variáveis de sessão necessárias estão definidas
    if (!isset($_SESSION['personagem'], $_SESSION['local'], $_SESSION['user_name'])) {
        die("Variáveis de sessão necessárias não estão definidas.");
    }

    // Busca a data do último movimento do personagem
    $stmt = $pdo->prepare("SELECT data, destino FROM movpersonagens 
                          WHERE personagem = :personagem 
                          ORDER BY data DESC LIMIT 1");
    $stmt->bindParam(':personagem', $_SESSION['personagem']);
    $stmt->execute();
    $ultimo_movimento = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$ultimo_movimento) {
        die("Histórico de movimento do personagem não encontrado.");
    }

    // Verifica se o destino do último movimento corresponde ao local atual
    if ($ultimo_movimento['destino'] !== $_SESSION['local']) {
        die("O personagem não está no local correto.");
    }

    $data_chegada = $ultimo_movimento['data'];

    // Processar envio de nova mensagem
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fala'])) {
        // Verifica se já passou 10 segundos desde a última mensagem
        if (isset($_SESSION['ultima_mensagem']) && (time() - $_SESSION['ultima_mensagem']) < 10) {
            die("Aguarde 10 segundos entre mensagens.");
        }
        
        $fala = trim($_POST['fala']);
        $direcionada = isset($_POST['direcionada']) ? trim($_POST['direcionada']) : null;
        
        if (!empty($fala)) {
            // Busca o nome do personagem pelo ID da sessão
            $stmt = $pdo->prepare("SELECT personagem FROM personagens WHERE id = :id");
            $stmt->bindParam(':id', $_SESSION['personagem'], PDO::PARAM_INT);
            $stmt->execute();
            $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$resultado) {
                die("Erro: Personagem não encontrado!");
            }
            
            $nome_personagem = $resultado['personagem'];
            
            // Insere a mensagem no chat
            $stmt = $pdo->prepare("INSERT INTO chatpersonagens 
                                  (personagem, jogador, fala, direcionada, local) 
                                  VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([
                $nome_personagem,
                $_SESSION['user_name'],
                $fala,
                $direcionada,
                $_SESSION['local']
            ]);
            
            // Registra o momento da última mensagem
            $_SESSION['ultima_mensagem'] = time();
            
            // Redireciona para evitar reenvio ao atualizar a página
            header("Location: ".$_SERVER['PHP_SELF']);
            exit();
        }
    }

    // Recuperar mensagens do chat (apenas após a chegada no local)
    $stmt = $pdo->prepare("SELECT personagem, fala, direcionada, dataehora 
                           FROM chatpersonagens 
                           WHERE local = :local 
                           AND dataehora >= :data_chegada
                           ORDER BY dataehora ASC");
    $stmt->execute([
        ':local' => $_SESSION['local'],
        ':data_chegada' => $data_chegada
    ]);
    $mensagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Busca o nome do personagem atual para verificação de mensagens
    $stmt = $pdo->prepare("SELECT personagem FROM personagens WHERE id = :id");
    $stmt->bindParam(':id', $_SESSION['personagem'], PDO::PARAM_INT);
    $stmt->execute();
    $meu_personagem = $stmt->fetch(PDO::FETCH_ASSOC);
    $nome_personagem_atual = $meu_personagem['personagem'];

} catch (PDOException $e) {
    die("Erro no banco de dados: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat do RPG</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .chat-container {
            background-color: white;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
            height: 400px;
            overflow-y: auto;
            display: flex;
            flex-direction: column-reverse;
        }
        .mensagens-wrapper {
            display: flex;
            flex-direction: column;
        }
        .mensagem {
            margin-bottom: 10px;
            padding: 8px;
            border-bottom: 1px solid #eee;
        }
        .mensagem .cabecalho {
            font-weight: bold;
            margin-bottom: 5px;
        }
        .mensagem .data {
            font-size: 0.8em;
            color: #666;
        }
        .mensagem.propria {
            background-color: #e6f2ff;
            border-left: 3px solid #4d94ff;
        }
        .mensagem.privada {
            background-color: #fff9e6;
            border-left: 3px solid #ffcc00;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        textarea {
            height: 60px;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }
        input[type="text"] {
            padding: 8px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }
        button {
            padding: 10px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        .aviso-tempo {
            color: #ff0000;
            font-size: 0.9em;
            margin-top: 5px;
        }
    </style>
    <script>
        // Função para manter o scroll no final do chat
        function manterScrollNoFinal() {
            const container = document.querySelector('.chat-container');
            container.scrollTop = container.scrollHeight;
        }
        
        // Executa quando a página carrega
        window.onload = manterScrollNoFinal;
    </script>
</head>
<body>
    <h1>Chat - <?php echo htmlspecialchars($_SESSION['local']); ?></h1>
    
    <div class="chat-container">
        <div class="mensagens-wrapper">
            <?php foreach ($mensagens as $msg): 
                $isPropria = ($msg['personagem'] === $nome_personagem_atual);
                $isPrivada = (!empty($msg['direcionada']));
                
                // Verifica se a mensagem privada é para o personagem atual
                $mostrarMensagem = true;
                if ($isPrivada && $msg['direcionada'] !== $nome_personagem_atual && !$isPropria) {
                    $mostrarMensagem = false;
                }
                
                if ($mostrarMensagem):
            ?>
                <div class="mensagem <?php echo $isPropria ? 'propria' : ''; ?> <?php echo $isPrivada ? 'privada' : ''; ?>">
                    <div class="cabecalho">
                        <?php echo htmlspecialchars($msg['personagem']); ?>
                        <?php if ($isPrivada): ?>
                            <span style="font-style: italic; font-weight: normal;">
                                (para <?php echo htmlspecialchars($msg['direcionada']); ?>)
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="texto"><?php echo nl2br(htmlspecialchars($msg['fala'])); ?></div>
                    <div class="data"><?php echo date('d/m/Y H:i', strtotime($msg['dataehora'])); ?></div>
                </div>
            <?php 
                endif;
            endforeach; 
            ?>
        </div>
    </div>
    
    <form method="POST" action="">
        <textarea name="fala" placeholder="Digite sua mensagem..." required></textarea>
        <input type="text" name="direcionada" placeholder="Personagem destinatário (opcional)">
        <button type="submit">Enviar</button>
        <?php if (isset($_SESSION['ultima_mensagem']) && (time() - $_SESSION['ultima_mensagem']) < 10): ?>
            <div class="aviso-tempo">
                Aguarde <?php echo 10 - (time() - $_SESSION['ultima_mensagem']); ?> segundos para enviar outra mensagem.
            </div>
        <?php endif; ?>
    </form>
</body>
</html>